#include <bits/stdc++.h>
#define F first
#define S second
#define endl '\n'
typedef long long ll;
typedef long double ld;
using namespace std;

struct Point {
    ld x, y;
    Point() {}
    Point(ld x, ld y) : x(x), y(y) {}
    bool operator<(Point& other) {
        if (x == other.x)
            return y < other.y;
        return x < other.x;
    }
};
struct Segment {
    Point s, e;
    Segment() {}
    pair <ld, ld> kb() {
        // x1 * k + b = y1
        // x2 * k + b = y2
        ld k = ld(s.y - e.y) / (s.x - e.x);
        ld b = s.y - s.x * k;
        return {k, b};
    }
    pair <bool, pair <ld, ld>> per(Segment& other) {
        auto [k1, b1] = kb();
        auto [k2, b2] = other.kb();
        // k1 * x + b1 = y
        // k2 * x + b2 = y
        ld x = ld(b2 - b1) / (k1 - k2);
        ld y = k1 * x + b1;
        if (x < min(s.x, e.x) || x > max(s.x, e.x))
            return {false, {0, 0}};
        if (x < min(other.s.x, other.e.x) || x > max(other.s.x, other.e.x))
            return {false, {0, 0}};
        return {true, {x, y}};
    }
};

bool used[16000000];
vector <int> g[16000000];
const ld EPS = 1e-9;

int dfs(int s, int p) {
    used[s] = 1;
    int ret = 0;
    for (auto& e : g[s]) {
        if (p != s && used[e] == 1)
            ret++;
        if (used[e] == 0)
            ret += dfs(e, s);
    }
    used[s] = 2;
    return ret;
}

void solve() {
    int n;
    cin >> n;
    vector <Segment> v(n);
    for (auto& i : v)
        cin >> i.s.x >> i.s.y >> i.e.x >> i.e.y;
    vector <pair <ld, ld>> pnt;
    pnt.reserve(n * (n - 1) / 2);
    for (int i = 0; i < n; i++)
        for (int j = 0; j < i; j++) {
            auto now = v[i].per(v[j]);
            if (now.F)
                pnt.push_back(now.S);
        }
    sort(pnt.begin(), pnt.end());
    for (int i = 0; i < pnt.size(); i++)
        g[i].clear();
    for (int i = 0; i < n; i++) {
        vector <pair <ld, ld>> t;
        t.reserve(n);
        for (int j = 0; j < i; j++) {
            auto now = v[i].per(v[j]);
            if (now.F)
                t.push_back(now.S);
        }
        sort(t.begin(), t.end());
        vector <int> ind;
        ind.reserve(t.size());
        for (auto& j : t)
            ind.push_back(lower_bound(pnt.begin(), pnt.end(), make_pair(j.F - EPS, j.S - EPS)) - pnt.begin());
        for (int j = 0; j + 1 < t.size(); j++) {
            g[ind[j]].push_back(ind[j + 1]);
            g[ind[j + 1]].push_back(ind[j]);
        }
    }
    int ans = 0;
    fill(used, used + pnt.size(), false);
    for (int i = 0; i < pnt.size(); i++)
        if (!used[i])
            ans += dfs(i, -1);
    cout << ans / 2 << endl;
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int tt = 1;
    cin >> tt;
    while (tt--)
        solve();
    cerr << "Ulyanovsk is the best!" << endl;
}
